
# Configuration file for the fletch build
set(fletch_VERSION 1.6.0)
set(fletch_ROOT "/opt/kitware/fletch_master")
set(fletch_WITH_PYTHON true)
set(fletch_PYTHON_MAJOR_VERSION 3)

########################################
# Boost
########################################
# If we are using MSVC 2017 make sure the CMake version is sufficient
if(MSVC AND (NOT MSVC_VERSION LESS 1910))
  # Get the CMAKE version string and make sure it's not a release candidate and >= 3.8.0
  if( (CMAKE_VERSION MATCHES "^3\\.8\\.0-rc") OR (CMAKE_VERSION VERSION_LESS 3.8.0))
    message(FATAL_ERROR "CMake 3.8.0 is the minimum version required to use Boost with Visual Studio 2017 or greater")
  endif()
endif()
set(Boost_USE_STATIC_LIBS OFF)
set(Boost_USE_MULTITHREADED ON)
set(Boost_USE_STATIC_RUNTIME OFF)
if(WIN32)
  add_definitions(-DBOOST_ALL_NO_LIB)
  add_definitions(-DBOOST_PROGRAM_OPTIONS_DYN_LINK)
endif()
set(Boost_ADDITIONAL_VERSIONS )
set(Boost_NO_SYSTEM_PATHS ON)
set(Boost_NO_BOOST_CMAKE ON)
set(BOOST_ROOT ${fletch_ROOT})

set(fletch_ENABLED_Boost TRUE)
set(Boost_SELECT_VERSION 1.78.0)
########################################
# ZLib
########################################
set(ZLIB_ROOT ${fletch_ROOT})

set(fletch_ENABLED_ZLib TRUE)

################################
# libjpeg-turbo
################################
set(libjpeg-turbo_ROOT ${fletch_ROOT})
set(fletch_ENABLED_libjpeg-turbo TRUE)

################################
# libtiff
################################
set(libtiff_ROOT ${fletch_ROOT})

set(fletch_ENABLED_libtiff TRUE)

################################_
# PNG
################################
set(PNG_ROOT ${fletch_ROOT})
set(fletch_ENABLED_PNG TRUE)

################################
# openjpeg
################################
set(openjpeg_ROOT ${fletch_ROOT})
set(fletch_ENABLED_openjpeg TRUE)

#######################################
# FFmpeg
#######################################
set(FFmpeg_ROOT ${fletch_ROOT})
set(fletch_ENABLED_FFmpeg TRUE)
set(FFmpeg_SELECT_VERSION 3.3.3)
########################################
# EIGEN
########################################
set(Eigen3_DIR ${fletch_ROOT}/share/eigen3/cmake)
set(fletch_ENABLED_Eigen TRUE)
set(Eigen_SELECT_VERSION 3.3.9)
########################################
# log4cplus
########################################
set(log4cplus_ROOT   ${fletch_ROOT})
set(log4cplus_DIR    ${fletch_ROOT}/lib/cmake/log4cplus)
set(fletch_ENABLED_log4cplus TRUE)

#######################################
# GFlags
#######################################
set(GFlags_ROOT ${fletch_ROOT})
set(fletch_ENABLED_GFlags TRUE)

#######################################
# GLog
#######################################
set(GLog_ROOT ${fletch_ROOT})
if(WIN32)
  set(GLog_DIR ${fletch_ROOT}/CMake)
else()
  set(GLog_DIR ${fletch_ROOT}/lib/cmake/GLog)
endif()
set(fletch_ENABLED_GLog TRUE)

########################################
# GTest
########################################
set(GTEST_ROOT ${fletch_ROOT})
set(fletch_ENABLED_GTest TRUE)

########################################
# OpenBLAS
########################################
set(OpenBLAS_ROOT    ${fletch_ROOT})
set(OpenBLAS_SELECT_VERSION 0.3.21)
########################################
# SuiteSparse
########################################
set(SuiteSparse_ROOT ${fletch_ROOT})
set(SuiteSparse_INCLUDE_DIR ${fletch_ROOT}/include)
set(fletch_ENABLED_SuiteSparse TRUE)

########################################
# Ceres
########################################
set(Ceres_ROOT ${fletch_ROOT})
if(WIN32)
  set(Ceres_DIR ${fletch_ROOT}/CMake)
else()
  set(Ceres_DIR ${fletch_ROOT}/lib/cmake/Ceres)
endif()

set(fletch_ENABLED_Ceres TRUE)

########################################
# libxml2
########################################
set(LIBXML2_ROOT    ${fletch_ROOT})
set(LIBXML2_LIBNAME xml2)

set(fletch_ENABLED_libxml2 TRUE)

########################################
# libjson
########################################
set(LIBJSON_ROOT    ${fletch_ROOT})
set(LIBJSON_LIBNAME json)

set(fletch_ENABLED_libjson TRUE)

########################################
# shapelib
########################################
set(SHAPELIB_ROOT    ${fletch_ROOT})
set(SHAPELIB_LIBNAME shp)

set(fletch_ENABLED_shapelib TRUE)

########################################
# TinyXML
########################################
set(TinyXML1_ROOT ${fletch_ROOT})

set(fletch_ENABLED_TinyXML1 TRUE)

########################################
# TinyXML
########################################
set(TinyXML2_ROOT ${fletch_ROOT})

set(fletch_ENABLED_TinyXML2 TRUE)

########################################
# libkml
########################################
set(KML_ROOT    ${fletch_ROOT})
set(KML_DIR     ${fletch_ROOT}/lib/cmake)
set(KML_LIBNAME kml)

set(fletch_ENABLED_libkml TRUE)
########################################
# Qt
########################################
set(Qt5_DIR ${fletch_ROOT}/lib/cmake/Qt5)

set(fletch_ENABLED_Qt TRUE)
set(Qt_SELECT_VERSION 5.12.8)
########################################
# OpenCV
########################################
set(OpenCV_ROOT ${fletch_ROOT})
if(WIN32)
  set(OpenCV_DIR ${OpenCV_ROOT})
else()
  set(OpenCV_DIR ${OpenCV_ROOT}/share/OpenCV)
endif()
set(OpenCV_VERSION 3.4.0)
set(fletch_ENABLED_OpenCV TRUE)
set(OpenCV_SELECT_VERSION 3.4.0)
########################################
# SQLite3
########################################
set(SQLite3_ROOT ${fletch_ROOT})
set(SQLite3_DIR ${fletch_ROOT}/share/cmake)

########################################
# PROJ4
########################################
set(PROJ4_ROOT ${fletch_ROOT})
set(PROJ_ROOT ${fletch_ROOT})
set(PROJ4_INCLUDE_DIR ${fletch_ROOT}/include)
set(PROJ_INCLUDE_DIR ${fletch_ROOT}/include)

set(fletch_ENABLED_PROJ TRUE)

########################################
# libgeotiff
########################################
set(libgeotiff_ROOT ${fletch_ROOT})
set(libgeotiff_LIBRARY ${libgeotiff_LIBRARY})

set(fletch_ENABLED_libgeotiff TRUE)

########################################
# GEOS
########################################
set(GEOS_ROOT ${fletch_ROOT})
set(GEOS_C_LIBRARY /opt/kitware/fletch_master/lib/libgeos_c.so)
set(fletch_ENABLED_GEOS TRUE)

########################################
# GDAL
########################################
set(GDAL_ROOT    ${fletch_ROOT})
set(ENV{GDAL_ROOT} ${fletch_ROOT})
set(fletch_ENABLED_GDAL TRUE)
set(GDAL_SELECT_VERSION 2.4.4)
########################################
# PDAL
########################################
set(PDAL_ROOT    ${fletch_ROOT})
set(PDAL_DIR ${fletch_ROOT}/lib/pdal/cmake)
set(PDAL_INCLUDE_DIR ${fletch_ROOT}/include)

set(fletch_ENABLED_PDAL TRUE)

########################################
# GeographicLib
########################################
set(GeographicLib_ROOT ${fletch_ROOT})

set(fletch_ENABLED_GeographicLib TRUE)

########################################
# PostgreSQL
########################################
set(PostgreSQL_ROOT ${fletch_ROOT})
set(fletch_ENABLED_PostgreSQL TRUE)
set(PostgreSQL_SELECT_VERSION 9.5.1)
########################################
# CppDB
########################################
set(CppDB_ROOT /opt/kitware/fletch_master)
set(fletch_ENABLED_CppDB TRUE)

########################################
# VTK
########################################
set(VTK_ROOT ${fletch_ROOT})
set(VTK_DIR ${fletch_ROOT}/lib/cmake/vtk-9.1)

set(fletch_ENABLED_VTK TRUE)
set(VTK_SELECT_VERSION 9.1)
################################
# VXL
################################
set(VXL_ROOT ${fletch_ROOT})
set(VXL_DIR ${fletch_ROOT}/share/vxl/cmake)

set(fletch_ENABLED_VXL TRUE)

########################################
# LMDB
########################################
set(LMDB_ROOT    ${fletch_ROOT})

#######################################
# HDF5
#######################################
set(HDF5_ROOT ${fletch_ROOT})
set(fletch_ENABLED_HDF5 TRUE)
set(HDF5_SELECT_VERSION 1.12.0)
########################################
# Snappy
########################################
set(SNAPPY_ROOT    ${fletch_ROOT})

########################################
# LevelDB
########################################
set(LevelDB_ROOT    ${fletch_ROOT})

#######################################
# Google Protobuf
#######################################
set(Protobuf_ROOT ${fletch_ROOT})
set(Protobuf_SELECT_VERSION 3.4.1)
########################################
# Darknet
########################################
set(Darknet_ROOT    ${fletch_ROOT})
set(Darknet_DIR     ${fletch_ROOT}/CMake)
set(fletch_ENABLED_Darknet TRUE)

################################
# pybind11
################################
set(pybind11_ROOT ${fletch_ROOT})
set(pybind11_DIR ${fletch_ROOT}/share/cmake/pybind11/)
set(fletch_ENABLED_pybind11 TRUE)
set(pybind11_SELECT_VERSION 2.5.0)
########################################
# YAMLcpp
########################################
set(yaml-cpp_ROOT    ${fletch_ROOT})
if(WIN32 AND NOT CYGWIN)
  set(yaml-cpp_DIR     ${fletch_ROOT}/CMake)
else()
  set(yaml-cpp_DIR     ${fletch_ROOT}/lib/cmake/yaml-cpp)
endif()

set(fletch_ENABLED_YAMLCPP TRUE)

########################################
# qtExtensions
########################################
set(qtExtensions_ROOT ${fletch_ROOT})
set(qtExtensions_DIR  ${fletch_ROOT}/lib/cmake/qtExtensions)

set(fletch_ENABLED_qtExtensions TRUE)
set(qtExtensions_SELECT_VERSION latest)
#######################################
# ZeroMQ
#######################################
set(ZeroMQ_ROOT   ${fletch_ROOT})

#######################################
# cppzmq
#######################################
set(cppzmq_ROOT   ${fletch_ROOT})
set(cppzmq_INCLUDE_DIR )
set(cppzmq_SELECT_VERSION 4.2.3)
